/*
 * Decompiled with CFR 0.152.
 */
package jclass.bwt;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import jclass.bwt.JCContainer;
import jclass.bwt.SplitterWindowSeparator;
import jclass.util.JCUtilConverter;

public class JCSplitterWindow
extends JCContainer {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    int dir = 0;
    int min_child_size = 20;
    boolean resized = false;
    private static final String base = "splitterwindow";
    private static int nameCounter;
    static final String[] orient_strings;
    static final int[] orient_values;

    public JCSplitterWindow() {
        this(0, null, null);
    }

    public JCSplitterWindow(int n) {
        this(n, null, null);
    }

    public JCSplitterWindow(int n, Applet applet, String string) {
        super(applet, string);
        if (string == null) {
            this.setName(base + nameCounter++);
        }
        this.dir = n;
        if (this.getClass().getName().equals("jclass.bwt.JCSplitterWindow")) {
            this.getParameters(applet);
        }
        this.setLayout(null);
    }

    protected void getParameters() {
        super.getParameters();
        this.dir = JCContainer.conv.toEnum(this.getParam("Orientation"), "orientation", orient_strings, orient_values, this.dir);
        this.min_child_size = JCContainer.conv.toInt(this.getParam("MinChildSize"), this.min_child_size);
    }

    public int getOrientation() {
        return this.dir;
    }

    public void setOrientation(int n) {
        JCUtilConverter.checkEnum(n, "orientation", orient_values);
        this.dir = n;
        this.layout();
    }

    public int getMinChildSize() {
        return this.min_child_size;
    }

    public void setMinChildSize(int n) {
        this.min_child_size = n;
    }

    public Component add(Component component) {
        if (this.countComponents() % 2 != 0) {
            super.add(new SplitterWindowSeparator(this));
        }
        return super.add(component);
    }

    protected int preferredHeight() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.countComponents()) {
            int n3 = this.getComponents()[n2].preferredSize().height;
            n = this.dir == 1 ? (n += n3) : Math.max(n, n3);
            ++n2;
        }
        return n;
    }

    protected int preferredWidth() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.countComponents()) {
            int n3 = this.getComponents()[n2].preferredSize().width;
            n = this.dir == 0 ? (n += n3) : Math.max(n, n3);
            ++n2;
        }
        return n;
    }

    public synchronized void layout() {
        int n = this.insets().left;
        int n2 = this.insets().top;
        int n3 = this.size().width - this.insets().left - this.insets().right;
        int n4 = this.size().height - this.insets().top - this.insets().bottom;
        int n5 = 0;
        while (n5 < this.countComponents()) {
            int n6;
            int n7;
            Component component = this.getComponents()[n5];
            Dimension dimension = this.resized && component.size().width > 0 && component.size().height > 0 ? component.size() : component.preferredSize();
            if (n5 != this.countComponents() - 1) {
                n7 = this.dir == 1 ? n3 : dimension.width;
                n6 = this.dir == 0 ? n4 : dimension.height;
            } else {
                n7 = this.dir == 1 ? n3 : n3 - n;
                n6 = this.dir == 0 ? n4 : n4 - n2;
            }
            component.reshape(n, n2, n7, n6);
            n += this.dir == 1 ? 0 : dimension.width + 1;
            n2 += this.dir == 1 ? dimension.height + 1 : 0;
            ++n5;
        }
    }

    public final void setLayout(LayoutManager layoutManager) {
    }

    static {
        orient_strings = new String[]{"horizontal", "vertical"};
        orient_values = new int[]{0, 1};
    }
}

